/* $Id: shmgen.c,v 1.1 2023/02/14 05:06:56 urabe Exp $ */
/* "shmgen.c"    2023.2.13 urabe */
/* generate dummy data blocks in SHM */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else  /* !TIME_WITH_SYS_TIME */
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else  /* !HAVE_SYS_TIME_H */
#include <time.h>
#endif  /* !HAVE_SYS_TIME_H */
#endif  /* !TIME_WITH_SYS_TIME */

#include "winlib.h"

static const char rcsid[] =
  "$Id: shmgen.c,v 1.1 2023/02/14 05:06:56 urabe Exp $";

char *progname,*logfile;
int syslog_mode=0,exit_status;
struct Shm *shm;
int debug=0;
char tb[200];

void
usage(void)
{
  WIN_version();
  fprintf(stderr,"%s\n",rcsid);
  fprintf(stderr,
    " usage : '%s (-D) [out_key] [shm_size(KB)] [size(B)] [rate(msg/s)] ([log file])'\n", progname);
}

void
one_block(int size)
{
  int i;
  uint8_w *ptw,*ptr;
  uint32_w uni;
  struct tm *nt;     /* 64 bit ok */
  int rt[6];     /* 64 bit ok */
  time_t t;

  ptw=shm->d+shm->p;
  uni=size+12; /* size+tow+payload+size */
  *ptw++=uni>>24; /* size (H) */
  *ptw++=uni>>16;
  *ptw++=uni>>8;
  *ptw++=uni;     /* size (L) */
  uni=(uint32_w)(time(NULL)-TIME_OFFSET);
  *ptw++=uni>>24;  /* tow (H) */
  *ptw++=uni>>16;
  *ptw++=uni>>8;
  *ptw++=uni;      /* tow (L) */
  /* payload */
  t=time(NULL);
  nt=localtime(&t);
  ptw[0]=d2b[nt->tm_year-100];
  ptw[1]=d2b[nt->tm_mon+1];
  ptw[2]=d2b[nt->tm_mday];
  ptw[3]=d2b[nt->tm_hour];
  ptw[4]=d2b[nt->tm_min];
  ptw[5]=d2b[nt->tm_sec];
  ptw+=size;
  uni=size+12; /* size+tow+payload+size */
  *ptw++=uni>>24; /* size (H) */
  *ptw++=uni>>16;
  *ptw++=uni>>8;
  *ptw++=uni;     /* size (L) */
  if(debug>0) {
    for(i=0;i<16;i++) printf("%02X",shm->d[shm->p+i]);
    printf(" :%6d b written\n",uni);
  }
  shm->r=shm->p;
  if(ptw>shm->d+(unsigned long)shm->pl) ptw=shm->d;
  shm->p=ptw-shm->d;
  shm->c++;
}

int
main(int argc, char *argv[])
  {
  key_t rawkey;
  int size_mes,rate,intvl,c;
  size_t size_shm;

  if((progname=strrchr(argv[0],'/'))!=NULL) progname++;
  else progname=argv[0];

  while((c=getopt(argc,argv,"D"))!=-1)
    {
    switch(c)
      {
      case 'D':   /* debug print */
        debug++;
        break;
      default:
        fprintf(stderr," option -%c unknown\n",c);
        usage();
        exit(1);
      }
    }
  optind--;
  if(argc<4+optind)
    {
    usage();
    exit(1);
    }
  rawkey=atol(argv[1+optind]);
  size_shm=(size_t)atol(argv[2+optind])*1000;
  size_mes=atoi(argv[3+optind]);
  rate=atoi(argv[4+optind]);
  if(argc>5+optind) logfile=argv[5+optind];
  else logfile=NULL;

  write_log("start");

  /* out shared memory */
  shm=Shm_create(rawkey,size_shm,"out");
  Shm_init(shm,size_shm);

  signal(SIGTERM,(void *)end_program);
  signal(SIGINT,(void *)end_program);

  intvl=1000000/rate;

  while(1) {
    one_block(size_mes);
    usleep(intvl);
  }
}
